/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiDropDown;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiMapName;
import xaero.map.gui.GuiMapSwitchingButton;
import xaero.map.gui.TooltipButton;
import xaero.map.misc.KeySortableByOther;
import xaero.map.world.MapDimension;
import xaero.map.world.MapWorld;

public class GuiMapSwitching {
    private MapProcessor mapProcessor;
    private MapDimension settingsDimension;
    private String[] mwDropdownValues;
    private class_4185 switchingButton;
    private class_4185 multiworldTypeOptionButton;
    private class_4185 renameButton;
    private class_4185 deleteButton;
    private CursorBox serverSelectionModeBox = new CursorBox("gui.xaero_mw_server_box");
    private CursorBox mapSelectionBox = new CursorBox("gui.xaero_map_selection_box");
    public boolean active;
    private boolean writableOnInit;

    public GuiMapSwitching(MapProcessor mapProcessor) {
        this.mapProcessor = mapProcessor;
        this.mapSelectionBox.setStartWidth(200);
        this.serverSelectionModeBox.setStartWidth(200);
    }

    public void init(GuiMap mapScreen, List<GuiDropDown> dropdowns, class_310 minecraft, int width, int height) {
        this.multiworldTypeOptionButton = null;
        MapWorld mapWorld = this.mapProcessor.getMapWorld();
        MapDimension mapDimension = this.settingsDimension = mapWorld == null || mapWorld.getCurrentDimensionId() == null ? null : mapWorld.getCurrentDimension();
        if (this.settingsDimension != null && mapWorld.isMultiplayer()) {
            this.writableOnInit = this.settingsDimension.futureMultiworldWritable;
            this.switchingButton = new GuiMapSwitchingButton(this.active, 0, height - 20, b -> {
                this.active = !this.active;
                mapScreen.method_25423(minecraft, width, height);
            });
            mapScreen.addButton(this.switchingButton);
            if (this.active) {
                String currentMultiworld = this.settingsDimension.getFutureMultiworldUnsynced();
                ArrayList<KeySortableByOther<String>> sortableList = new ArrayList<KeySortableByOther<String>>();
                for (String string : this.settingsDimension.getMultiworldIdsCopy()) {
                    sortableList.add(new KeySortableByOther<String>(string, new Comparable[]{this.settingsDimension.getMultiworldName(string).toLowerCase()}));
                }
                Collections.sort(sortableList);
                ArrayList<String> dropdownValuesList = new ArrayList<String>();
                for (KeySortableByOther keySortableByOther : sortableList) {
                    dropdownValuesList.add((String)keySortableByOther.getKey());
                }
                int n = this.getDropdownSelectionIdFromValue(dropdownValuesList, currentMultiworld);
                if (n == dropdownValuesList.size()) {
                    dropdownValuesList.add(currentMultiworld);
                }
                this.mwDropdownValues = dropdownValuesList.toArray(new String[0]);
                List list = dropdownValuesList.stream().map(s -> this.settingsDimension.getMultiworldName((String)s)).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
                if (this.settingsDimension.getMapWorld().isMultiplayer()) {
                    list.add("\u00a78" + class_1074.method_4662((String)"gui.xaero_create_new_map", (Object[])new Object[0]));
                }
                GuiDropDown createdDropdown = new GuiDropDown(list.toArray(new String[0]), width / 2 - 100, 30, 200, n, (dd, i) -> {
                    if (i < this.mwDropdownValues.length) {
                        this.mapProcessor.setMultiworld(this.settingsDimension, this.mwDropdownValues[i]);
                        this.updateButtons();
                        return true;
                    }
                    minecraft.method_1507((class_437)new GuiMapName(this.mapProcessor, mapScreen, mapScreen, this.settingsDimension, null));
                    return false;
                }, true);
                dropdowns.add(createdDropdown);
                this.multiworldTypeOptionButton = new TooltipButton(0, height - 45, 150, 20, (class_2561)new class_2585(this.getMultiworldTypeButtonMessage()), b -> {
                    if (this.isMapSelectionOptionEnabled()) {
                        this.mapProcessor.toggleMultiworldType(this.settingsDimension);
                        b.method_25355((class_2561)new class_2585(this.getMultiworldTypeButtonMessage()));
                    }
                }, this.settingsDimension.isFutureMultiworldServerBased() ? this.serverSelectionModeBox : this.mapSelectionBox);
                mapScreen.addButton(this.multiworldTypeOptionButton);
                this.renameButton = new class_4185(width / 2 + 109, 26, 60, 20, (class_2561)new class_2588("gui.xaero_rename"), b -> minecraft.method_1507((class_437)new GuiMapName(this.mapProcessor, mapScreen, mapScreen, this.settingsDimension, this.settingsDimension.getFutureMultiworldUnsynced())));
                mapScreen.addButton(this.renameButton);
                this.deleteButton = new class_4185(width / 2 - 168, 26, 60, 20, (class_2561)new class_2588("gui.xaero_delete"), b -> {
                    if (this.settingsDimension.getFutureCustomSelectedMultiworld() != null) {
                        String selectedMWId = this.settingsDimension.getFutureCustomSelectedMultiworld();
                        minecraft.method_1507((class_437)new class_410(result -> {
                            if (result) {
                                String mapNameAndIdLine = class_1074.method_4662((String)"gui.xaero_delete_map_msg4", (Object[])new Object[0]) + ": " + this.settingsDimension.getMultiworldName(selectedMWId) + " (" + selectedMWId + ")";
                                minecraft.method_1507((class_437)new class_410(result2 -> {
                                    if (result2) {
                                        Object object = this.mapProcessor.uiSync;
                                        synchronized (object) {
                                            if (this.mapProcessor.getMapWorld() == this.settingsDimension.getMapWorld()) {
                                                MapDimension currentDimension;
                                                MapDimension mapDimension = currentDimension = !this.mapProcessor.isMapWorldUsable() ? null : this.mapProcessor.getMapWorld().getCurrentDimension();
                                                if (this.settingsDimension == currentDimension && this.settingsDimension.getCurrentMultiworld().equals(selectedMWId)) {
                                                    if (WorldMap.settings.debug) {
                                                        WorldMap.LOGGER.info("Delayed map deletion!");
                                                    }
                                                    this.mapProcessor.requestCurrentMapDeletion();
                                                } else {
                                                    if (WorldMap.settings.debug) {
                                                        WorldMap.LOGGER.info("Instant map deletion!");
                                                    }
                                                    this.settingsDimension.deleteMultiworldMapDataUnsynced(selectedMWId);
                                                }
                                                this.settingsDimension.deleteMultiworldId(selectedMWId);
                                                this.settingsDimension.pickDefaultCustomMultiworldUnsynced();
                                                this.settingsDimension.saveConfigUnsynced();
                                                this.settingsDimension.futureMultiworldWritable = false;
                                                mapScreen.method_25423(minecraft, width, height);
                                            }
                                        }
                                    }
                                    minecraft.method_1507((class_437)mapScreen);
                                }, (class_2561)new class_2588("gui.xaero_delete_map_msg3"), (class_2561)new class_2585(mapNameAndIdLine)));
                            } else {
                                minecraft.method_1507((class_437)mapScreen);
                            }
                        }, (class_2561)new class_2588("gui.xaero_delete_map_msg1"), (class_2561)new class_2588("gui.xaero_delete_map_msg2")));
                    }
                });
                mapScreen.addButton(this.deleteButton);
                this.updateButtons();
                this.multiworldTypeOptionButton.field_22763 = this.isMapSelectionOptionEnabled();
                this.renameButton.field_22763 = this.settingsDimension.getMapWorld().isMultiplayer();
                mapScreen.addButton(new class_4185(width / 2 - 50, 50, 100, 20, (class_2561)new class_2588("gui.xaero_confirm"), b -> this.confirm(mapScreen, minecraft, width, height)));
            }
        }
    }

    private boolean isMapSelectionOptionEnabled() {
        return !this.settingsDimension.isFutureMultiworldServerBased() && this.settingsDimension.getMapWorld().isMultiplayer();
    }

    private void updateButtons() {
        this.switchingButton.field_22763 = this.settingsDimension != null && this.settingsDimension.futureMultiworldWritable;
        this.deleteButton.field_22763 = this.settingsDimension.getMapWorld().isMultiplayer() && this.mwDropdownValues.length > 1 && this.settingsDimension.getFutureCustomSelectedMultiworld() != null;
    }

    private String getMultiworldTypeButtonMessage() {
        int multiworldType = this.settingsDimension.getMapWorld().getFutureMultiworldType(this.settingsDimension);
        return class_1074.method_4662((String)"gui.xaero_map_selection", (Object[])new Object[0]) + ": " + class_1074.method_4662((String)(this.settingsDimension.isFutureMultiworldServerBased() ? "gui.xaero_mw_server" : (multiworldType == 0 ? "gui.xaero_mw_single" : (multiworldType == 1 ? "gui.xaero_mw_manual" : "gui.xaero_mw_spawn"))), (Object[])new Object[0]);
    }

    public void confirm(GuiMap mapScreen, class_310 minecraft, int width, int height) {
        if (this.mapProcessor.confirmMultiworld(this.settingsDimension)) {
            this.active = false;
            mapScreen.method_25423(minecraft, width, height);
        }
    }

    private int getDropdownSelectionIdFromValue(List<String> values, String value) {
        int selected = 0;
        for (selected = 0; selected < values.size() && !values.get(selected).equals(value); ++selected) {
        }
        return selected;
    }

    public void preMapRender(GuiMap mapScreen, List<GuiDropDown> dropdowns, class_310 minecraft, int width, int height) {
        String currentDropdownSelection;
        String currentMultiworld;
        MapDimension currentDim;
        MapDimension mapDimension = currentDim = !this.mapProcessor.isMapWorldUsable() ? null : this.mapProcessor.getMapWorld().getCurrentDimension();
        if (currentDim != this.settingsDimension) {
            this.active = false;
            mapScreen.method_25423(minecraft, width, height);
        }
        if (!this.active && this.settingsDimension != null && !this.settingsDimension.futureMultiworldWritable) {
            this.active = true;
            mapScreen.method_25423(minecraft, width, height);
        }
        if (this.active && this.settingsDimension != null && dropdowns.get(0).isClosed() && (!(currentMultiworld = this.settingsDimension.getFutureMultiworldUnsynced()).equals(currentDropdownSelection = this.mwDropdownValues[dropdowns.get(0).getSelected()]) || this.writableOnInit != this.settingsDimension.futureMultiworldWritable)) {
            mapScreen.method_25423(minecraft, width, height);
        }
    }

    public void renderText(class_4587 matrixStack, class_310 minecraft, int mouseX, int mouseY, int width, int height) {
        if (!this.active) {
            return;
        }
        String selectMapString = class_1074.method_4662((String)"gui.xaero_select_map", (Object[])new Object[0]) + ":";
        minecraft.field_1772.method_1720(matrixStack, selectMapString, (float)(width / 2 - minecraft.field_1772.method_1727(selectMapString) / 2), 19.0f, -1);
    }

    public void postMapRender(class_4587 matrixStack, class_310 minecraft, int mouseX, int mouseY, int width, int height) {
    }
}

